/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.jei.ingredient.block;

import com.almostreliable.summoningrituals.recipe.component.BlockReference;
import com.almostreliable.summoningrituals.util.Bruhtils;
import com.almostreliable.summoningrituals.util.TextUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class BlockReferenceRenderer
implements IIngredientRenderer<BlockReference> {
    private final Minecraft mc = Minecraft.m_91087_();
    private final BlockRenderDispatcher blockRenderer = this.mc.m_91289_();
    private final int size;

    public BlockReferenceRenderer(int size) {
        this.size = size;
    }

    public void render(PoseStack stack, @Nullable BlockReference blockReference) {
        if (blockReference == null) {
            return;
        }
        stack.m_85836_();
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69453_();
        stack.m_85837_((double)(0.93f * (float)this.size), (double)(0.77f * (float)this.size), 100.0);
        stack.m_85841_(0.625f * (float)this.size, 0.625f * (float)this.size, 0.625f * (float)this.size);
        stack.m_85845_(Vector3f.f_122226_.m_122240_(180.0f));
        stack.m_85845_(Vector3f.f_122222_.m_122240_(30.0f));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
        MultiBufferSource.BufferSource bufferSource = this.mc.m_91269_().m_110104_();
        this.blockRenderer.renderSingleBlock(blockReference.getDisplayState(), stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
        bufferSource.m_109911_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        stack.m_85849_();
    }

    public List<Component> getTooltip(BlockReference blockReference, TooltipFlag tooltipFlag) {
        BlockState displayState = blockReference.getDisplayState();
        ItemStack stack = new ItemStack((ItemLike)displayState.m_60734_());
        try {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)TextUtils.translate("tooltip", "block_below", ChatFormatting.GOLD).m_130946_(": ").m_7220_((Component)((MutableComponent)stack.m_41786_()).m_130940_(ChatFormatting.WHITE)));
            if (tooltipFlag.m_7050_()) {
                tooltip.add((Component)new TextComponent(Bruhtils.getId(stack.m_41720_()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            this.appendStateTooltip(displayState, tooltip);
            return tooltip;
        }
        catch (Exception e) {
            return List.of(new TextComponent("Error rendering tooltip!").m_130946_(e.getMessage()).m_130940_(ChatFormatting.DARK_RED));
        }
    }

    public int getWidth() {
        return this.size;
    }

    public int getHeight() {
        return this.size;
    }

    private void appendStateTooltip(BlockState displayState, List<Component> tooltip) {
        BlockState defaultState = displayState.m_60734_().m_49966_();
        ArrayList<CallSite> modifiedProps = new ArrayList<CallSite>();
        for (Property property : displayState.m_61147_()) {
            if (displayState.m_61143_(property).equals(defaultState.m_61143_(property))) continue;
            modifiedProps.add((CallSite)((Object)(property.m_61708_() + ": " + displayState.m_61143_(property))));
        }
        if (modifiedProps.isEmpty()) {
            return;
        }
        tooltip.add((Component)TextUtils.translate("tooltip", "properties", ChatFormatting.AQUA).m_7220_((Component)TextUtils.colorize(":", ChatFormatting.AQUA)));
        for (String string : modifiedProps) {
            tooltip.add((Component)TextUtils.colorize("\u00bb ", ChatFormatting.GRAY).m_7220_((Component)TextUtils.colorize(string, ChatFormatting.WHITE)));
        }
    }
}

